 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_DEV_NCC_CANCELAMENTO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PDV_VD_DEV_NCC_CANCELAMENTO]
GO
--EXEC P_PDV_VD_DEV_NCC_CANCELAMENTO '2001-01-01','2017-11-16'  
CREATE PROCEDURE P_PDV_VD_DEV_NCC_CANCELAMENTO  @DT_INI DATETIME = NULL , 
												 @DT_FIM DATETIME = NULL 
WITH ENCRYPTION 
AS 
DECLARE @DIAS AS INT;

SET @DIAS  = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = 1 AND CD_CHAVE = 'QTDE_DIAS_BAIXA_NCC_AUTOMATICA'),1);

IF @DT_INI IS NULL
BEGIN
	SET @DT_INI=GETDATE()
	SET @DT_FIM=GETDATE()-30
END

CREATE TABLE #RsNCC (CD_CTR_NCC INT, 
					 STS_NCC INT,
					 DT_CAD DATETIME)

INSERT INTO #RsNCC
SELECT
	CD_CTR_NCC,
	STS_NCC,
	DT_CAD
FROM
	PDV_VD_DEV_NCC
WHERE
	DT_CAD BETWEEN  @DT_INI AND @DT_FIM

	
UPDATE
	PDV_VD_DEV_NCC
SET 
	PDV_VD_DEV_NCC.STS_NCC=0
FROM          
	#RsNCC PDV_VD_DEV_NCC LEFT OUTER JOIN PDV_VD_DEV_NCC_PDV_VD ON 
    PDV_VD_DEV_NCC.CD_CTR_NCC = PDV_VD_DEV_NCC_PDV_VD.CD_CTR_NCC 
WHERE     
	PDV_VD_DEV_NCC.STS_NCC IN (1,7)
	and PDV_VD_DEV_NCC_PDV_VD.CD_CTR_NCC  IS NULL
	
--NCC de devolucao usada na baixa de novas vendas (troca) 
UPDATE
	PDV_VD_DEV_NCC
SET  
	PDV_VD_DEV_NCC.STS_NCC = 1
FROM          
	#RsNCC PDV_VD_DEV_NCC INNER JOIN PDV_VD_DEV_NCC_PDV_VD ON 
    PDV_VD_DEV_NCC.CD_CTR_NCC = PDV_VD_DEV_NCC_PDV_VD.CD_CTR_NCC 
	INNER JOIN PDV_VD AS PDV_VD_NOVO ON
    PDV_VD_NOVO.CD_VD = PDV_VD_DEV_NCC_PDV_VD.CD_VD AND 
    PDV_VD_NOVO.CD_FILIAL = PDV_VD_DEV_NCC_PDV_VD.CD_FILIAL AND 
    PDV_VD_NOVO.CD_EMP = PDV_VD_DEV_NCC_PDV_VD.CD_EMP
WHERE     
	NOT PDV_VD_DEV_NCC.STS_NCC IN (1,7)
	AND PDV_VD_DEV_NCC.DT_CAD = PDV_VD_NOVO.DT_VD 

--Status nao existe 5
UPDATE
	PDV_VD_DEV_NCC
SET  
	PDV_VD_DEV_NCC.STS_NCC = 3
FROM          
	#RsNCC PDV_VD_DEV_NCC INNER JOIN PDV_VD_DEV_NCC_PDV_VD ON 
    PDV_VD_DEV_NCC.CD_CTR_NCC = PDV_VD_DEV_NCC_PDV_VD.CD_CTR_NCC 
WHERE     
	PDV_VD_DEV_NCC.STS_NCC =5

--NCC de devolucao usada na baixa de novas vendas (troca outro dia)
UPDATE
	PDV_VD_DEV_NCC
SET  
	PDV_VD_DEV_NCC.STS_NCC = 7
FROM          
	#RsNCC PDV_VD_DEV_NCC INNER JOIN PDV_VD_DEV_NCC_PDV_VD ON 
    PDV_VD_DEV_NCC.CD_CTR_NCC = PDV_VD_DEV_NCC_PDV_VD.CD_CTR_NCC 
	INNER JOIN PDV_VD AS PDV_VD_NOVO ON
    PDV_VD_NOVO.CD_VD = PDV_VD_DEV_NCC_PDV_VD.CD_VD AND 
    PDV_VD_NOVO.CD_FILIAL = PDV_VD_DEV_NCC_PDV_VD.CD_FILIAL AND 
    PDV_VD_NOVO.CD_EMP = PDV_VD_DEV_NCC_PDV_VD.CD_EMP  
WHERE     
	PDV_VD_DEV_NCC.STS_NCC = 1
	AND PDV_VD_DEV_NCC.DT_CAD <> PDV_VD_NOVO.DT_VD 

--NCC de devolucao de Baixa de parcela de crediario
UPDATE
	PDV_VD_DEV_NCC
SET 
	PDV_VD_DEV_NCC.STS_NCC =10 
FROM          
	#RsNCC PDV_VD_DEV_NCC INNER JOIN PDV_VD_DEV_NCC_LANC_CPL AS NCC_CPL ON 
	PDV_VD_DEV_NCC.CD_CTR_NCC = NCC_CPL.CD_CTR_NCC 
	INNER JOIN PDV_VD_DEV_NCC_LANC AS LANC ON 
	NCC_CPL.CD_CTR_LANC_NCC = LANC.CD_CTR_LANC_NCC 
	INNER JOIN PDV_VD_DEV_NCC_LANC_RC_CREDIARIO_PARC_CRED AS RC_CRED ON 
	LANC.CD_CTR_LANC_NCC = RC_CRED.CD_CTR_LANC_NCC 
	INNER JOIN RC_CREDIARIO_PARC_CRED ON 
	RC_CRED.CD_CTR_CRED = RC_CREDIARIO_PARC_CRED.CD_CTR_CRED AND 
    RC_CRED.CD_CTR = RC_CREDIARIO_PARC_CRED.CD_CTR 
WHERE
	PDV_VD_DEV_NCC.STS_NCC <> 10

--NCC de devolucao de baixa de duplicata
UPDATE
	PDV_VD_DEV_NCC
SET  
	PDV_VD_DEV_NCC.STS_NCC =4
FROM          
	#RsNCC PDV_VD_DEV_NCC INNER JOIN PDV_VD_DEV_NCC_LANC_CPL LANC_CPL ON 
	PDV_VD_DEV_NCC.CD_CTR_NCC = LANC_CPL.CD_CTR_NCC 
	INNER JOIN PDV_VD_DEV_NCC_LANC LANC ON 
	LANC.CD_CTR_LANC_NCC = LANC_CPL.CD_CTR_LANC_NCC 
	INNER JOIN PDV_VD_DEV_NCC_LANC_RC_CRED NCC_CRED ON 
	LANC.CD_CTR_LANC_NCC = NCC_CRED.CD_CTR_LANC_NCC 
WHERE
	PDV_VD_DEV_NCC.STS_NCC <> 4

--NCC de devolucao usada na baixa de vendas de convenio
UPDATE
	PDV_VD_DEV_NCC
SET  
	PDV_VD_DEV_NCC.STS_NCC = 8
FROM          
	#RsNCC PDV_VD_DEV_NCC INNER JOIN PDV_VD_DEV_NCC_LANC_CPL AS NCC_CPL ON 
	PDV_VD_DEV_NCC.CD_CTR_NCC = NCC_CPL.CD_CTR_NCC 
	INNER JOIN PDV_VD_DEV_NCC_LANC AS LANC ON 
	NCC_CPL.CD_CTR_LANC_NCC = LANC.CD_CTR_LANC_NCC 
	INNER JOIN PDV_VD_DEV_NCC_LANC_RC_VD_CONV_CRED AS RC_CRED ON 
	LANC.CD_CTR_LANC_NCC=RC_CRED.CD_CTR_LANC_NCC 
	INNER JOIN RC_VD_CONV_CRED ON
	RC_CRED.CD_CTR_CRED=RC_VD_CONV_CRED.CD_CTR_CRED AND
	RC_CRED.CD_CTR=RC_VD_CONV_CRED.CD_CTR 
	INNER JOIN RC_VD_CONV ON 
	RC_CRED.CD_CTR=RC_VD_CONV.CD_CTR 
WHERE
	PDV_VD_DEV_NCC.STS_NCC <> 8

UPDATE
	PDV_VD_DEV_NCC
SET
	PDV_VD_DEV_NCC.STS_NCC = ncc.STS_NCC
FROM
	PDV_VD_DEV_NCC INNER JOIN #RsNCC ncc ON
	PDV_VD_DEV_NCC.CD_CTR_NCC = ncc.CD_CTR_NCC
WHERE
	PDV_VD_DEV_NCC.STS_NCC <> ncc.STS_NCC

UPDATE
	PDV_VD_DEV_NCC
SET
	PDV_VD_DEV_NCC.STS_NCC = 3
FROM         
	PDV_VD_DEV_NCC 
WHERE     
	PDV_VD_DEV_NCC.STS_NCC = 0
	AND PDV_VD_DEV_NCC.DT_CAD < CONVERT(CHAR(10),GETDATE()-@DIAS,112)	

UPDATE
	PDV_VD_DEV_NCC
SET
	PDV_VD_DEV_NCC.STS_NCC = 11
FROM         
	PDV_VD_DEV_NCC 
WHERE     
	PDV_VD_DEV_NCC.STS_NCC = 0
	AND PDV_VD_DEV_NCC.DT_CAD < CONVERT(CHAR(10),GETDATE()-@DIAS,112)	
	and PDV_VD_DEV_NCC.TIPO_NCC=8
		
DROP TABLE #RsNCC